################################################################################
## Exemplo 1 - Ajuste de uma exponencial ##
################################################################################
## Vamos precisar destes pacotes
library(bbmle)
library(sads)
## Simulamos uma amostra de uma exponencial com lambda = 0,1 e de tamanho 100
dados1 <- rexp(n=100, rate = 0.1)
## Inspeção visual com histograma
hist(dados1, prob = TRUE)
### I. Calculo do MLE pela solução analítica ###
1/mean(dados1)
## Adiciona a curva de densidade da exponencial ajustada aos dados
## valores para calcular as densidades
x <- seq( min(dados1), max(dados1), length = 100)
## Adiciona a linha
lines( x = x, y = dexp(x, rate = 1/mean(dados1)), col = "blue")
## Cálculo da log-verossimilhaca negativa analitica
LL1 <- function(lambda){
    N <- length(dados1)
    sx <- sum(dados1)
    -(N*log(lambda) - sx*lambda)
}
## Esta funcao pode ser aplicada a qualquer valor de lambda
## por exemplo o MLE para estes dados
LL1(1/mean(dados1))
## Ou o valor da distribuicao de onde foram tomadas as amostras
## nesta simulacao
LL1(0.1)
## Grafico do perfil de log-verossimilhança negativa
## Primeiro criamos os valores de lambda
## para os quais calcular a log-verossimilhança
lambdas <- seq(lambda*0.75, lambda*1.3, length = 100)
## Calculo da log-verossimilhanca para cada valor 
dados1.LLs <- LL1(lambdas)
## Converte em log-verossimilhanca relativa:
## Como estamos em escala log, subtraimos da mínima verossimilhança
dados1.LLr <- dados1.LLs - LL1(1/mean(dados1))
## Perfil de log-verossimilhança relativa
plot( x= lambdas, y = dados1.LLr, type = "l")
## Limite do intervalo de plausibilidade
abline( h = log(8), lty =2, col = "red")

### II. Ajuste numerico da exponencial aos mesmos dados ###
## Criamos funcao de verossmilhança como funcao
## da densidade probabilistica
LL2 <- function(lambda){
    -sum( dexp(x = dados1, rate = lambda, log = TRUE) )
}
## Comparando o resultado desta funcao para o MLE
## com o resultado da funcao que faz o calculo analitico
LL2(1/mean(dados1))
LL1(1/mean(dados1))
## Para o ajuste numeŕico
## Entregamos a funcao LL2 para o otimizador
dados1.mle2 <- mle2(LL2, start = list(lambda = 0.1))
## Inspecionando o objeto resultante
## classe do objeto
class(dados1.mle2)
## Resumo do ajuste
summary(dados1.mle2)
## Coeficiente (ou seja o mle)
coef(dados1.mle2)
## Comparando com o valor analitico
1/mean(dados1)
## Verossimilhanca
logLik(dados1.mle2)
## Comparando com p calculo analitico
LL1(1/mean(dados1))
## Calculando perfil de verossimilhanca
dados1.prf <- profile(dados1.mle2)
## Plota o perfil
plotprofmle(dados1.prf)

################################################################################
## Ajuste computacional de uma Weibull
################################################################################
## Leitura e exploracao dos dados
parag <- read.table( "parago-sobrev.csv", header=T)
## Apenas arvores com DAP > 25
dap <- parag$dap[parag$dap>25]
## Re-escalona a medida para zero quando DAP =25
dap0 <- dap - 25
## Histograma
hist(dap0, main="")
## Funcao de log-verossimilhanca negativa
nllweibull = function(escala, forma){
  -sum( dweibull(dap0, shape=forma, scale=escala, 
                 log=TRUE) )
}
## Ajuste. Valores iniciais "chutados"
parag.wei = mle2(nllweibull, 
                 start=list(escala=20, forma=1))
## MLEs obtidos pelo ajuste
coef(parag.wei)

## Log-verossimilhanca do ajuste
logLik(parag.wei)

## Perfil de log-verossimilhanca negativa e intervalos de plausibilidade
parag.prf <- profile(parag.wei)
par(mfrow=c(1,2)) # para mostrar s dois perfis em um painel
plotprofmle(parag.prf)
par(mfrow=c(1,1))
