## ----include=FALSE------------------------------------------------------------
library(knitr)
opts_chunk$set(
eval=TRUE, tidy=FALSE, echo=TRUE, fig.path='figuras/fig', prompt=TRUE, comment=NA, cache =FALSE
)


## ----settings, echo=F---------------------------------------------------------
## options(SweaveHooks=list(fig=function()par(lwd=3, cex.lab=1.5,
##     cex.axis=1.5, las=1, mar=c(5,5.5,4,2), mgp=c(4,1,0))))
knit_hooks$set(fig=function()par(lwd=3, cex.lab=1.5,
    cex.axis=1.5, las=1, mar=c(5,5.5,4,2), mgp=c(4,1,0)))
library(xtable)


## ----exponencial-dados--------------------------------------------------------
x <- rexp(100, rate=0.1)


## ----exp-mle, echo=TRUE-------------------------------------------------------
(L1 <- 1/mean(x))


## ----exp-LL-analitica, echo=T-------------------------------------------------
nllexp <- function(lambda){
    N <- length(x)
    sx <- sum(x)
   -(N*log(lambda) - lambda*sx)
}


## ----exp-LL-analitica-min, echo=T---------------------------------------------
nllexp(lambda = L1)


## ----exp-funcao-logver, echo=T------------------------------------------------
LL.e2 <- function(lambda){ 
    -sum(dexp(x, rate=lambda, log=TRUE)) 
}


## ----exp-ajuste, eval=T, echo=T-----------------------------------------------
library(bbmle) #basta uma vez
m1 <- mle2( LL.e2, start=list(lambda=L1) )


## ----exp-result-analitico-----------------------------------------------------
L1
nllexp(lambda=L1)


## ----exp-comparando-ajustes, eval=T, echo=T-----------------------------------
coef(m1)
logLik(m1)


## ----weib-prep-dados, echo=FALSE, include=FALSE-------------------------------
parag <- read.table(
"parago-sobrev.csv", header=T)
dap <- parag$dap[parag$dap>25]
dap0 <- dap - 25
hist(dap0, main="")


## ----weib-prep-dados, eval=FALSE----------------------------------------------
## parag <- read.table(
## "parago-sobrev.csv", header=T)
## dap <- parag$dap[parag$dap>25]
## dap0 <- dap - 25
## hist(dap0, main="")


## ----hist-weibull, fig=T, echo=F----------------------------------------------
hist(dap0, main="", col="darkgrey")


## ----weib-funcao-logver, echo=T-----------------------------------------------
nllweibull = function(escala, forma){
  -sum( dweibull(dap0, shape=forma, scale=escala, 
                 log=TRUE) )
}


## ----weib-ajuste, eval=T, echo=T, warning=FALSE-------------------------------
parag.wei = mle2(nllweibull, 
  start=list(escala=20, forma=1))


## ----weib-mle-----------------------------------------------------------------
coef(parag.wei)


## ----weib-loglikelihood-------------------------------------------------------
logLik(parag.wei)    


## ----exp-curva-ll, include=F--------------------------------------------------
library(sads)
m1.p <- profile(m1)
plotprofmle(m1.p)


## ----exp-curva-ll, eval=FALSE-------------------------------------------------
## library(sads)
## m1.p <- profile(m1)
## plotprofmle(m1.p)


## ----exp-curva-ll, echo=F, fig=T, out.height = "0.75\\textheight"-------------
library(sads)
m1.p <- profile(m1)
plotprofmle(m1.p)


## ----exp-curva-ic, include=F--------------------------------------------------
plot(m1.p)
confint(m1.p)


## ----exp-curva-ic, eval=FALSE-------------------------------------------------
## plot(m1.p)
## confint(m1.p)


## ----exp-ic-fig, echo=F, fig=T------------------------------------------------
plot(m1.p)


## ----geom-fit, include=F, echo=F----------------------------------------------
## Gera dados para um exemplo
x2 <- rgeom(500, prob = 0.1)
## mle analitico
p1 <- length(x2)/(length(x2)+sum(x2))
## Para construir o grafico
obs <- table(factor(x2,levels=0:max(x2)))
plot(obs/sum(obs), xlab="N Intervalos", 
     ylab="Proporcao")
lines(0:max(x2), dgeom(0:max(x2), p1),
      col="blue", lty=2, type="b")


## ----geom-fit-cdf, include=F, echo=F------------------------------------------
plot(ecdf(x2), xlab = "N de intervalos", ylab= "Prob acumulada",
     pch=1, main = "")
lines(0:max(x2), pgeom(0:max(x2), prob = p1), col = "blue", lwd=2)


## ----geom-fit, echo=F, fig=T, out.height = "0.75\\textheight"-----------------
## Gera dados para um exemplo
x2 <- rgeom(500, prob = 0.1)
## mle analitico
p1 <- length(x2)/(length(x2)+sum(x2))
## Para construir o grafico
obs <- table(factor(x2,levels=0:max(x2)))
plot(obs/sum(obs), xlab="N Intervalos", 
     ylab="Proporcao")
lines(0:max(x2), dgeom(0:max(x2), p1),
      col="blue", lty=2, type="b")


## ----geom-fit-cdf, echo=F, fig=T, out.height = "0.75\\textheight"-------------
plot(ecdf(x2), xlab = "N de intervalos", ylab= "Prob acumulada",
     pch=1, main = "")
lines(0:max(x2), pgeom(0:max(x2), prob = p1), col = "blue", lwd=2)


## ----geom-fit, eval=FALSE-----------------------------------------------------
## ## Gera dados para um exemplo
## x2 <- rgeom(500, prob = 0.1)
## ## mle analitico
## p1 <- length(x2)/(length(x2)+sum(x2))
## ## Para construir o grafico
## obs <- table(factor(x2,levels=0:max(x2)))
## plot(obs/sum(obs), xlab="N Intervalos",
##      ylab="Proporcao")
## lines(0:max(x2), dgeom(0:max(x2), p1),
##       col="blue", lty=2, type="b")


## ----weib-fit, include=F, echo=F----------------------------------------------
pw.cf <- coef(parag.wei)
hist(dap0, prob=T, main="", xlab = "DAP - 25 (cm)")
curve(dweibull(x, shape=pw.cf[2], scale=pw.cf[1]),
      add=T, col="blue")


## ----weib-fit-cum, include=F, echo=F------------------------------------------
plot(ecdf(dap0), xlab = "DAP - 25 (cm)",
     ylab = "P acumulada", pch=1, ce =0.75, main ="")
lines(pweibull(0:max(dap0), shape=pw.cf[2], scale=pw.cf[1]),
               col = "blue", lwd = 2)


## ----weib-fit, echo=F, fig=T, out.height = "0.75\\textheight"-----------------
pw.cf <- coef(parag.wei)
hist(dap0, prob=T, main="", xlab = "DAP - 25 (cm)")
curve(dweibull(x, shape=pw.cf[2], scale=pw.cf[1]),
      add=T, col="blue")


## ----weib-fit-cum, echo=F, fig=T, out.height = "0.75\\textheight"-------------
plot(ecdf(dap0), xlab = "DAP - 25 (cm)",
     ylab = "P acumulada", pch=1, ce =0.75, main ="")
lines(pweibull(0:max(dap0), shape=pw.cf[2], scale=pw.cf[1]),
               col = "blue", lwd = 2)


## ----weib-fit, eval=FALSE-----------------------------------------------------
## pw.cf <- coef(parag.wei)
## hist(dap0, prob=T, main="", xlab = "DAP - 25 (cm)")
## curve(dweibull(x, shape=pw.cf[2], scale=pw.cf[1]),
##       add=T, col="blue")


## ----tab-quantil-prep, include=F, echo=F--------------------------------------
x2 <- sort(rnorm(100))
x2p <- (1:length(x2))/length(x2)
df1 <- data.frame(Percentil=x2p,Observado=x2, 
                  Esperado=qnorm(x2p))


## ----tab-qqplot, echo=F, results='asis', fig=F--------------------------------
print(xtable(head(df1), digits=3))


## ----weib-qqplot, include=F---------------------------------------------------
dap.P <- ppoints(dap0)
dap.pred <- qweibull(dap.P, shape=pw.cf[2], 
                     scale=pw.cf[1])
plot(sort(dap0)~dap.pred, xlab="Quantis teoricos",
     ylab="Quantis empiricos")
abline(0,1, col="red")


## ----weib-qqplot, eval=FALSE--------------------------------------------------
## dap.P <- ppoints(dap0)
## dap.pred <- qweibull(dap.P, shape=pw.cf[2],
##                      scale=pw.cf[1])
## plot(sort(dap0)~dap.pred, xlab="Quantis teoricos",
##      ylab="Quantis empiricos")
## abline(0,1, col="red")


## ----weib-qqplot,fig=T, echo=F------------------------------------------------
dap.P <- ppoints(dap0)
dap.pred <- qweibull(dap.P, shape=pw.cf[2], 
                     scale=pw.cf[1])
plot(sort(dap0)~dap.pred, xlab="Quantis teoricos",
     ylab="Quantis empiricos")
abline(0,1, col="red")


## ----weib-qqplot-right, fig=T, echo=F-----------------------------------------
hist(dap0, prob=T, main="")
curve(dweibull(x, 
               shape=pw.cf[2], 
               scale=pw.cf[1]),
      add=T, col="blue")
options(SweaveHooks=list(fig=function()par(lwd=3, cex.lab=1.5,
    cex.axis=1.5, las=1, mar=c(5,5.5,0.5,0.5), mgp=c(4,1,0))))


## ----ks-test, echo=F, include=F-----------------------------------------------
set.seed(42)
x2 <- sort(rgamma(200, shape=1.3, rate=0.5))
LL.g <- function(s,r) -sum(dgamma(x2,shape=s, rate=r, log=T))
LL.e <- function(r) -sum(dexp(x2,rate=r, log=T))
x2.mg <- mle2(LL.g, start=list(s=1,r=0.5))
x2.me <- mle2(LL.e, start=list(r=1))
cf.mg <- coef(x2.mg)
cf.me <- coef(x2.me)
x2.p <- ppoints(x2)
x2.q <- quantile(x2,x2.p)
x2.pe <- pexp(x2.q,rate=cf.me)
x2.pg <- pgamma(x2.q,shape=cf.mg[1],rate=cf.mg[2])
x2.dif <- abs(x2.p-x2.pg)
x2.ind <- x2.dif==max(x2.dif)


## ----ks-plot, fig=T, echo=F---------------------------------------------------
plot(x2.p~x2.q, type="l", xlab="Quantil", ylab="Percentil (Prob acumulada)", col="black")
lines(x2.pg~x2.q,col="blue", lty=2)
segments(x0=x2.q[x2.ind],
         y0=x2.p[x2.ind],
         x1=x2.q[x2.ind],
         y1=x2.pg[x2.ind],
         lwd=3, col="red")


## ----tab-aic, echo=F, results='asis', fig=F-----------------------------------
t1 <- AICtab(x2.mg,x2.me, base=T)
aictab <- data.frame(LogLik=sapply(c(x2.mg,x2.me),logLik), 
                     gl=t1$df, AIC=t1$AIC, dAIC=t1$dAIC,
                     row.names=c("gama","exponencial"))
print(xtable(aictab, digits=1))

