
## ----settings, echo=F, include = FALSE----------------------------------------
library(xtable)
library(bbmle)
library(MASS)
library(sads)


## ----dados-galton, echo=F-----------------------------------------------------
## Leitura dos dados do site https://www.randomservices.org/random/data/Galton.html
galton <- read.table("https://www.randomservices.org/random/data/Galton.txt", header=TRUE)
## Toma apenas o primeiro filho de cada família
galton1 <- galton[!duplicated(galton$Family),]


## ----dados-galton-summary, tidy=FALSE-----------------------------------------
head(galton1, 5)


## ----grafico-maes, echo=FALSE, fig=TRUE, out.width="0.65\\textwidth"----------
plot(Height ~ Mother, data = galton1,
     xlab="Altura da mãe (in)", ylab="Altura do(a) filho(a) (in)")


## ----log-lik-galton1----------------------------------------------------------
galton.LL1 <- function(a0, a1, b0){
    PL <- a0 + a1*galton1$Mother
    -sum( dnorm(galton1$Height, mean = PL, sd = b0 ,
                log=T))}


## ----fit-galton1, include = FALSE---------------------------------------------
galton.m1 <- mle2(galton.LL1,
                  start = list(a0=0, a1=1, b0=5))


## ----mle-galtonm1-------------------------------------------------------------
coef(galton.m1)


## ----loglik-galtonm1----------------------------------------------------------
logLik(galton.m1)


## ----obsXprevistos-maes, echo=FALSE, fig=TRUE, out.width="0.65\\textwidth"----
cfs <- coef(galton.m1)
plot(Height ~ Mother, data = galton1,
     xlab="Altura do mãe (in)", ylab="Altura do(a) filho(a) (in)")
abline(cfs[1], cfs[2], col = "blue", lwd =1.25)


## ----galton-perfil, include =FALSE--------------------------------------------
galton.m1.prf <- profile(galton.m1)
pdf("figuras/perfis_maes.pdf", height= 2.5, width = 7)
par(mfrow=c(1,3))
plotprofmle(galton.m1.prf)
par(mfrow=c(1,1))
dev.off()



## ----fit-linear-lm------------------------------------------------------------
galton.lm1 <- lm(Height ~ Mother, data = galton1)


## ----mle-galtonm1-------------------------------------------------------------
coef(galton.m1)


## ----coefs-lm-----------------------------------------------------------------
coef(galton.lm1)


## ----loglik-galtonm1----------------------------------------------------------
logLik(galton.m1)


## ----logLik-lm----------------------------------------------------------------
	logLik(galton.lm1)


## ----grafico-maes-residuo1, echo=FALSE, fig=TRUE, out.width="0.65\\textwidth"----
galton.m1.fit <- cfs[1] + cfs[2]*galton1$Mother
plot(Height ~ Mother, data = galton1,
     xlab="Altura do mãe (in)", ylab="Altura do(a) filho(a) (in)")
abline(cfs[1], cfs[2], col = "blue", lwd =1.25)
segments(x0 = galton1$Mother[58], y0 = galton1$Height[58], y1=galton.m1.fit[58],
         col = "red", lwd=2)


## ----grafico-maes3-residuo2, echo=FALSE, fig=TRUE, out.width="0.65\\textwidth"----
plot(Height ~ Mother, data = galton1,
     xlab="Altura do mãe (in)", ylab="Altura do(a) filho(a) (in)")
abline(cfs[1], cfs[2], col = "blue", lwd =1.25)
segments(x0 = galton1$Mother, y0 = galton1$Height, y1=galton.m1.fit,
         col = "red")


## ----plot-residuos-all, echo=FALSE, figure = TRUE-----------------------------
par(mfrow=c(2,2))
plot(galton.lm1)
par(mfrow=c(1,1))


## ----plot-residuos, echo=F, figure = TRUE, out.width="0.65\\textwidth"--------
plot(galton.lm1, which=1)


## ----QQplot-residuos, echo=F, figure = TRUE, out.width="0.65\\textwidth"------
plot(galton.lm1, which=2)


## ----galton-modelos-multiplos, include = FALSE--------------------------------
## Interacao fraca nao está muito didatico
galton.m2 <- lm(Height ~ Mother + Gender, data = galton1)
cf2 <- coef(galton.m2)
galton.m3 <- lm(Height ~ Mother * Gender, data = galton1)
cf3 <- coef(galton.m3)


## ----galton-plot-aditivo, include=FALSE---------------------------------------
Y <- jitter(galton1$Height)
X <- jitter(galton1$Mother)
index <- galton1$Gender=="M"
plot(X, Y, type = "n",
     xlab = "Altura da mãe (in)", ylab = "Altura do(a) filho(a) (in)")
points(X[index], Y[index], col="deeppink", pch =19, cex = 0.75)
points(X[!index], Y[!index], col="blue", pch=19, cex=0.75)
legend("topleft", c("Meninas", "Meninos"), pch =19, col = c("blue", "deeppink"), bty = "n")
abline(cf2[1] + cf2[3], cf2[2], col = "deeppink")
abline(cf2[1], cf2[2], col = "blue")


## ----galton-plot-inter, include=FALSE-----------------------------------------
plot(X, Y, type = "n",
     xlab = "Altura da mãe (in)", ylab = "Altura do(a) filho(a) (in)")
points(X[index], Y[index], col="deeppink", pch =19, cex = 0.75)
points(X[!index], Y[!index], col="blue", pch=19, cex=0.75)
legend("topleft", c("Meninas", "Meninos"), pch =19, col = c("blue", "deeppink"), bty = "n")
abline(cf3[1] + cf3[3], cf3[2]+cf3[4], col = "deeppink")
abline(cf3[1], cf3[2], col = "blue")


## ----plot_aditivo, figure=TRUE, echo=FALSE, out.width="0.65\\textwidth"-------
    plot(X, Y, type = "n",
         xlab = "Altura da mãe (in)", ylab = "Altura do(a) filho(a) (in)")
    legend("topleft", c("Meninas", "Meninos"), lty=1, col = c("blue", "deeppink"), bty = "n", cex=1.25)
    abline(cf2[1] + cf2[3], cf2[2] , col = "deeppink")
    abline(cf2[1], cf2[2], col = "blue")


## ----plot_teorico_interacao, figure=TRUE, echo=FALSE, out.width="0.65\\textwidth"----
plot(X, Y, type = "n",
     xlab = "Altura da mãe (in)", ylab = "Altura do(a) filho(a) (in)")
legend("topleft", c("Meninas", "Meninos"), lty=1, col = c("blue", "deeppink"), bty = "n", cex=1.25)
abline(cf3[1]-2 , cf3[2]+ 0.1 , col = "deeppink", lwd=2)
abline(cf3[1]+5, cf3[2]-0.1, col = "blue", lwd = 2)


## ----read_johnson, include=FALSE----------------------------------------------
johnson <- read.csv("johnson.txt", row.names=1)


## ----dados-johnson-summary, tidy=FALSE----------------------------------------
head(johnson, 4)


## ----log-lik-johnson-nls------------------------------------------------------
johnson.LL <- function(a0, a1, b0){
    PL <- a0*johnson$area^a1
    -sum( dnorm(johnson$Nspp, mean = PL, sd = b0 ,
                log=T))}


## ----fit-johnson-nls, include = FALSE-----------------------------------------
johnson.m1 <- mle2(johnson.LL,
                  start = list(a0=200, a1=0.25, b0=10)
                  )



## ----obsXprevistos-nls, echo=FALSE, fig=TRUE, out.width="0.65\\textwidth"-----
cfs3 <- coef(johnson.m1)
plot(Nspp ~ area, data = johnson,
     xlab="Área do local", ylab="N de espécies")
curve(cfs3[1]*x^cfs3[2], add=TRUE, col = "blue", lwd =1.25)


## ----johnson-perfil, include =FALSE-------------------------------------------
johnson.m1.prf <- profile(johnson.m1)
pdf("figuras/perfis_johnson.pdf", height= 2.5, width = 7)
par(mfrow=c(1,3))
plotprofmle(johnson.m1.prf)
par(mfrow=c(1,1))
dev.off()


## ----fit-nls------------------------------------------------------------------
johnson.nls <- nls(Nspp ~ a0*area^a1, data = johnson)


## ----mle-johnson-m1-----------------------------------------------------------
coef(johnson.m1)


## ----coefs_nls----------------------------------------------------------------
coef(johnson.nls)


## ----loglik-johnson-m1--------------------------------------------------------
logLik(johnson.m1)


## ----logLik-nls---------------------------------------------------------------
logLik(johnson.nls)


